%% JY5325单通道连续采集示例
clc;clear;
% 加载JY5325的类库
NET.addAssembly('C:\SeeSharp\JYTEK\Hardware\DAQ\JY5325\Bin\JY5325.dll');
% 创建采集任务
aiTask=JY5325.JY5325AITask(0);
% 添加通道,2个通道
rangeHigh=double(10.0);        % 输入高范围10V
rangeLow=double(-10.0);        % 输入低范围-10V
aiTask.AddChannel(int32(0),rangeLow,rangeHigh);     % 添加通道0
% 设置基本参数
aiTask.Mode=JY5325.AIMode.Continuous;  % 设置采集模式为连续采集
sampleRate=1000000;              % 采样率为1M
aiTask.SampleRate=double(sampleRate);       % 设置采样率为1MS/s
sampleToAcquire=200000;            % 采样点数200k
aiTask.SamplesToAcquire=int32(sampleToAcquire);    % 设置采样点数，即单次触发采集点数
aiTask.Trigger.Type=JY5325.AITriggerType.Immediate;    % 设置触发模式为立即触发
sampleTime=sampleToAcquire/sampleRate;
sampleInterval=1.0/sampleRate;
t=0:sampleInterval:sampleTime-sampleInterval;    % 减去最后一个间隔
% 开始采集
aiTask.Start();
% 初始化数据，分配空间
channelCount=int32(aiTask.Channels.Count);     % 通道数
readData=NET.createArray('System.Double',sampleToAcquire);

% 创建图窗并设置键盘回调
hFig=figure('Name','Esc退出示例','NumberTitle','off');
setappdata(hFig,'stop',false);
set(hFig,'WindowKeyPressFcn',@(src,evt)setappdata(src,'stop',strcmp(evt.Key,'escape')));
% 创建图窗B，用于绘图
hPlot=figure('Name','绘图窗','NumberTitle','off');
ax=axes('Parent',hPlot);

% 创建while循环读取数据
count=0;       % 打印点数
while true
    avaliableSamples=double(aiTask.AvailableSamples);     % 获取缓冲区点数
    % 打印缓冲区点数
    fprintf(repmat('\b',1,count));
    count=fprintf('The availableSamples: %d',int32(avaliableSamples));
    if avaliableSamples >= sampleToAcquire
        % 等待采集完成并读取数据
        aiTask.ReadData(readData,sampleToAcquire,int32(10000));
        readDataMW=double(readData);       % 转换
        plot(ax,t,readDataMW);    % 绘制波形图
        % 处理UI事件以触发回调
        drawnow;
    else
        pause(0.1);     % 暂停0.1s
    end

    % 检查是否按下ESC
    if getappdata(hFig,'stop')
        fprintf('\n');
        disp('检测到ESC，退出循环');
        break;
    end
end

% 停止采集
aiTask.Stop();
aiTask.Channels.Clear();

