%% JY5325单通道有限点输出示例
clc;clear;
% ===========================
% 常量配置（根据需要修改）
% ===========================
slotNumber=int32(0);      % 机箱槽位索引
channelIndex=int32(0);    % AO通道号
updateRate=10000.0;       % 更新率
samplesToUpdate=int32(200000);       % 有限点输出样本数
waveType='sine';          % 信号类型'sine'|'square'|'noise'
amplitude=2.0;            % 振幅(±V)
frequency=100.0;          % 频率(Hz)，仅正弦/方波有效

% JY5325 .NET程序集路径
jyDllPath='C:\SeeSharp\JYTEK\Hardware\DAQ\JY5325\Bin\JY5325.dll';
% ===========================
% 载入.NET程序集
% ===========================
NET.addAssembly(jyDllPath);
import JY5325.*

% ===========================
% 生成输出波形
% ===========================
N=double(samplesToUpdate);
t=(0:N-1)/updateRate;
switch lower(waveType)
    case 'sine'
        writeValue=amplitude*sin(2*pi*frequency*t);
    case 'square'
        writeValue=amplitude*sign(sin(2*pi*frequency*t));    % 50%占空比
    case 'noise'
        writeValue=amplitude*(2*rand(1,N)-1);    % 统一白噪声，幅度±amplitude
    otherwise
        error('Unsupported waveType: %s',waveType);
end
% 可视化（便于核对输出波形）
figure('Name', 'AO Finite Output (Preview)');
plot(t, double(writeValue));
xlabel('Time (s)'); ylabel('Voltage (V)');
title(sprintf('AO Finite - %s', upper(waveType))); grid on;

% 转为 System.Double[]（与 C# 的 double[] 对齐，确保类型匹配）
data = NET.createArray('System.Double', numel(writeValue));
for i = 1:numel(writeValue)
    data(i) = writeValue(i);
end

% ===========================
% 建立并配置AO有限点任务
% ===========================
aoTask=JY5325AOTask(slotNumber);
cleanupObj = onCleanup(@()safeCleanup(aoTask)); % 自动清理，异常也能收尾
% 采样时钟：内部时钟
aoTask.SampleClock.Source = AOSampleClockSource.Internal;
% 添加通道
aoTask.AddChannel(channelIndex);
% 基本参数
aoTask.Mode            = AOMode.Finite;
aoTask.UpdateRate      = updateRate;
aoTask.SamplesToUpdate = samplesToUpdate;

% =========================
% 写数据并启动
% =========================
aoTask.WriteData(data, int32(-1)); % -1 表示无限等待
aoTask.Start();

% 轮询等待任务完成（与 C# timer/WaitUntilDone(10) 语义一致）
count=0;       % 打印点数
while ~aoTask.WaitUntilDone(int32(10))
    avaliableSamples=double(aoTask.AvaliableLenInSamples);     % 获取缓冲区点数
    % 打印缓冲区点数
    fprintf(repmat('\b',1,count));
    count=fprintf('The availableSamples: %d',int32(avaliableSamples));
    pause(0.1);
end
fprintf('\n');
% 停止与清理
aoTask.Stop();
aoTask.Channels.Clear();